/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.rbf.RbfRequest;
import com.ibm.hwmca.fw.rbf.impl.HandlerManager;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Iterator;

public final class RbfUtils {
    private RbfUtils() {
    }

    public static String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        throwable.printStackTrace(new PrintStream(baos));
        return baos.toString();
    }

    public static String getMachineInfo(MachineId machine) {
        return machine.getName() + "/" + RbfUtils.getIpAddress(machine);
    }

    public static String getMachineInfo(Collection machines) {
        if (machines == null || machines.isEmpty()) {
            return null;
        }
        StringBuffer machineInfo = new StringBuffer();
        Iterator iterator = machines.iterator();
        while (iterator.hasNext()) {
            MachineId machine = (MachineId)iterator.next();
            if (machineInfo.length() <= 0) {
                machineInfo.append(machine.getName() + "/" + RbfUtils.getIpAddress(machine));
                continue;
            }
            machineInfo.append(", " + machine.getName() + "/" + RbfUtils.getIpAddress(machine));
        }
        return machineInfo.toString();
    }

    public static String getIpAddress(MachineId machineId) {
        String ipAddr = "127.0.0.1";
        if (machineId == null) {
            return ipAddr;
        }
        InetAddress inetAddr = null;
        InetAddress[] nicAddrs = machineId.getNicAddresses();
        for (int i = 0; i < nicAddrs.length; ++i) {
            if (nicAddrs[i].isAnyLocalAddress()) continue;
            if (nicAddrs[i].isLoopbackAddress()) {
                if (inetAddr != null) continue;
                inetAddr = nicAddrs[i];
                continue;
            }
            if (nicAddrs[i].isSiteLocalAddress()) {
                if (inetAddr != null && !inetAddr.isLoopbackAddress()) continue;
                inetAddr = nicAddrs[i];
                continue;
            }
            inetAddr = nicAddrs[i];
            break;
        }
        if (inetAddr != null) {
            ipAddr = inetAddr.getHostAddress();
        }
        return ipAddr;
    }

    public static String getLoggingInfo() {
        return RbfUtils.getLoggingInfo(null);
    }

    public static String getLoggingInfo(RbfRequest request) {
        HandlerManager handlerMgr = HandlerManager.getHandlerManager();
        FcsServer fcsServer = FcsServer.getFcsServer();
        StringBuffer sb = new StringBuffer();
        sb.append("Local Machine:\n");
        sb.append("rbfVersion=2\n");
        sb.append("machineId=" + fcsServer.getLocalMachineId());
        if (request != null) {
            sb.append("\n\nRequest:\n");
            sb.append(request.toDebugString());
        }
        if (request != null) {
            sb.append("\n\nRequest History:\n");
            sb.append(request.getTrackingData().getHistoryDump());
        }
        sb.append("\n\nRequest Handler Topology:\n");
        sb.append(handlerMgr.getHandlersDump(false));
        return sb.toString();
    }
}

